---
description: "Learn more about: Date functions"
title: "Date functions"
ms.date: 03/29/2024
ms.custom: "nonautomated-date"
---
# Date functions

These functions create and manipulate the date component of date, datetime, and datetimezone values.

|Name|Description|
|------------|---------------|
|[Date.AddDays](date-adddays.md)|Returns a Date/DateTime/DateTimeZone value with the day portion incremented by the number of days provided. It also handles incrementing the month and year potions of the value as appropriate.|
|[Date.AddMonths](date-addmonths.md)|Returns a DateTime value with the month portion incremented by n months.|
|[Date.AddQuarters](date-addquarters.md)|Returns a Date/DateTime/DateTimeZone value incremented by the number of quarters provided. Each quarter is defined as a duration of three months. It also handles incrementing the year potion of the value as appropriate.|
|[Date.AddWeeks](date-addweeks.md)|Returns a Date/DateTime/DateTimeZone value incremented by the number of weeks provided. Each week is defined as a duration of seven days. It also handles incrementing the month and year potions of the value as appropriate.|
|[Date.AddYears](date-addyears.md)|Returns a DateTime value with the year portion incremented by n years.|
|[Date.Day](date-day.md)|Returns the day for a DateTime value.|
|[Date.DayOfWeek](date-dayofweek.md)|Returns a number (from 0 to 6) indicating the day of the week of the provided value.|
|[Date.DayOfWeekName](date-dayofweekname.md)|Returns the day of the week name.|
|[Date.DayOfYear](date-dayofyear.md)|Returns a number that represents the day of the year from a DateTime value.|
|[Date.DaysInMonth](date-daysinmonth.md)|Returns the number of days in the month from a DateTime value.|
|[Date.EndOfDay](date-endofday.md)|Returns the end of the day.|
|[Date.EndOfMonth](date-endofmonth.md)|Returns the end of the month.|
|[Date.EndOfQuarter](date-endofquarter.md)|Returns the end of the quarter.|
|[Date.EndOfWeek](date-endofweek.md)|Returns the end of the week.|
|[Date.EndOfYear](date-endofyear.md)|Returns the end of the year.|
|[Date.From](date-from.md)|Returns a date value from a value.|
|[Date.FromText](date-fromtext.md)|Creates a Date from local, universal, and custom Date formats.|
|[Date.IsInCurrentDay](date-isincurrentday.md)|Indicates whether the given datetime value `dateTime` occurs during the current day, as determined by the current date and time on the system.|
|[Date.IsInCurrentMonth](date-isincurrentmonth.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the current month, as determined by the current date and time on the system.|
|[Date.IsInCurrentQuarter](date-isincurrentquarter.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the current quarter, as determined by the current date and time on the system.|
|[Date.IsInCurrentWeek](date-isincurrentweek.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the current week, as determined by the current date and time on the system.|
|[Date.IsInCurrentYear](date-isincurrentyear.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the current year, as determined by the current date and time on the system.|
|[Date.IsInNextDay](date-isinnextday.md)|Indicates whether the given datetime value dateTime occurs during the next day, as determined by the current date and time on the system.|
|[Date.IsInNextMonth](date-isinnextmonth.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the next month, as determined by the current date and time on the system.|
|[Date.IsInNextNDays](date-isinnextndays.md)|Indicates whether the given datetime value dateTime occurs during the next number of days, as determined by the current date and time on the system.|
|[Date.IsInNextNMonths](date-isinnextnmonths.md)|Indicates whether the given datetime value dateTime occurs during the next number of months, as determined by the current date and time on the system.|
|[Date.IsInNextNQuarters](date-isinnextnquarters.md)|Indicates whether the given datetime value dateTime occurs during the next number of quarters, as determined by the current date and time on the system.|
|[Date.IsInNextNWeeks](date-isinnextnweeks.md)|Indicates whether the given datetime value dateTime occurs during the next number of weeks, as determined by the current date and time on the system.|
|[Date.IsInNextNYears](date-isinnextnyears.md)|Indicates whether the given datetime value dateTime occurs during the next number of years, as determined by the current date and time on the system.|
|[Date.IsInNextQuarter](date-isinnextquarter.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the next quarter, as determined by the current date and time on the system.|
|[Date.IsInNextWeek](date-isinnextweek.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the next week, as determined by the current date and time on the system.|
|[Date.IsInNextYear](date-isinnextyear.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the next year, as determined by the current date and time on the system.|
|[Date.IsInPreviousDay](date-isinpreviousday.md)|Indicates whether the given datetime value dateTime occurs during the previous day, as determined by the current date and time on the system.|
|[Date.IsInPreviousMonth](date-isinpreviousmonth.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the previous month, as determined by the current date and time on the system.|
|[Date.IsInPreviousNDays](date-isinpreviousndays.md)|Indicates whether the given datetime value dateTime occurs during the previous number of days, as determined by the current date and time on the system.|
|[Date.IsInPreviousNMonths](date-isinpreviousnmonths.md)|Indicates whether the given datetime value dateTime occurs during the previous number of months, as determined by the current date and time on the system.|
|[Date.IsInPreviousNQuarters](date-isinpreviousnquarters.md)|Indicates whether the given datetime value dateTime occurs during the previous number of quarters, as determined by the current date and time on the system.|
|[Date.IsInPreviousNWeeks](date-isinpreviousnweeks.md)|Indicates whether the given datetime value dateTime occurs during the previous number of weeks, as determined by the current date and time on the system.|
|[Date.IsInPreviousNYears](date-isinpreviousnyears.md)|Indicates whether the given datetime value dateTime occurs during the previous number of years, as determined by the current date and time on the system.|
|[Date.IsInPreviousQuarter](date-isinpreviousquarter.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the previous quarter, as determined by the current date and time on the system.|
|[Date.IsInPreviousWeek](date-isinpreviousweek.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the previous week, as determined by the current date and time on the system.|
|[Date.IsInPreviousYear](date-isinpreviousyear.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred during the previous year, as determined by the current date and time on the system.|
|[Date.IsInYearToDate](date-isinyeartodate.md)|Returns a logical value indicating whether the given Date/DateTime/DateTimeZone occurred in the period starting January 1st of the current year and ending on the current day, as determined by the current date and time on the system.|
|[Date.IsLeapYear](date-isleapyear.md)|Returns a logical value indicating whether the year portion of a DateTime value is a leap year.|
|[Date.Month](date-month.md)|Returns the month from a DateTime value.|
|[Date.MonthName](date-monthname.md)|Returns the name of the month component.|
|[Date.QuarterOfYear](date-quarterofyear.md)|Returns a number between 1 and 4 for the quarter of the year from a DateTime value.|
|[Date.StartOfDay](date-startofday.md)|Returns the start of the day.|
|[Date.StartOfMonth](date-startofmonth.md)|Returns the start of the month.|
|[Date.StartOfQuarter](date-startofquarter.md)|Returns the start of the quarter.|
|[Date.StartOfWeek](date-startofweek.md)|Returns the start of the week.|
|[Date.StartOfYear](date-startofyear.md)|Returns the start of the year.|
|[Date.ToRecord](date-torecord.md)|Returns a record containing parts of a Date value.|
|[Date.ToText](date-totext.md)|Returns a text value from a Date value.|
|[Date.WeekOfMonth](date-weekofmonth.md)|Returns a number for the count of week in the current month.|
|[Date.WeekOfYear](date-weekofyear.md)|Returns a number for the count of week in the current year.|
|[Date.Year](date-year.md)|Returns the year from a DateTime value.|
|[#date](sharpdate.md)|Creates a date value from year, month, and day.|
